# Charity Notes 09: Rambam 最高慈善等级的原因

今天我们着重讨论 Maimonides (i.e. Rambam) 的最高层次的慈善——即恢复穷人（rehabilitate the poor person）。他的方法总结如下：“提供贷款或合伙关系不仅有助于恢复贫困人口，而且可以保护他的尊严。“

上述理解是标准理解，可以阅读 ==Julie Salamon== 的书 Rambam’s Ladder 的现代应用，内容附在后面。今天的讨论我们将给出另一种解读。

在研究贫困和慈善事业时，学者们区分了**两种基本类型**的贫困（我正在利用马克·科恩（Mark Cohen）的书 Poverty and Charity in the Jewish community of Medieval Egypt, 34-35, 48），其中一个是“==结构性贫困==”（structural poverty）。对于那些生活在==永久性贫困==中的人来说，这是一种“结构性”的剥夺状态，其中由于某种原因，例如身体不好，身体残疾，丧偶或老年，他们找不到工作或其他可靠的生计手段。为了生存，这些人必须克服接受他人支持的耻辱。大多数的乞讨者都是此类人。

另一种类型包括那些在特定的，间歇性的情况下产生贫困或需要的人，这是Annalistes所说的“结合”的结果（==conjunctural poor==）。这些情况下的贫困是由于环境的特殊趋同导致他们的经济状况突然恶化（工厂在火灾中被摧毁，工人突然被解雇，库存丢失等）。突然的贫困，无论多么短暂，也是一种耻辱的来源。在中世纪和早期现代欧洲文本中称之为“羞耻的穷人”，拒绝向他人寻求帮助，更不用说诉诸公共救济或乞讨的尴尬。

有了这些背景信息，迈蒙尼德关于向穷人借钱的说法以及为什么它甚至比捐赠慈善机构更为明智，这是非常有趣的。

在诫命书 ( Sefer ha-misvot, Book of Commandments) 中很明显，迈蒙尼德重视向“羞耻的穷人”提供贷款的诫命。然而，只有少数人会听到“羞耻”的穷人所处的困境。因此，如果个别犹太人碰巧知道他们的困境，他有义务采取行动。而帮助这些**试图“挽回面子”的穷人的唯一方法就是借贷** - 因为他/她永远不会愿意接受慈善事业！

简而言之，我们从这段经文中了解到，迈蒙尼德敏锐地意识到“穷人”并非都是从同一块布上剪下来的。<u>正如有不同类型的穷人一样 - 在处理“贫困”时也需要采用不同类型的支持</u>。



## 利未记25:35

更令人感兴趣的是，当人们看到早期的塔木德文献时，人们也发现了一个强烈的迹象，表明他们已经意识到“结构性”永久性穷人和“结合”之间的这种基本区别，可能只是暂时的穷人。

利未记25:35中的经文“如果你的兄弟变得贫穷，他的手落下，那么你就会坚持（或强化）他......他将与你同住。”拉比解释说这节经文不是处理所有穷人，而是一个非常具体的人。

很明显，在塔木德圣人的眼中，利未记的这节经文正在处理“结合”的穷人，<u>一个尚未陷入完全贫困的人，但如果没有人来帮助和提升，他就会向这个方向前进他</u>。

迈蒙尼德写道：最高级别的慈善是为了挽回一个已经变得贫穷的犹太人，给他一份礼物，贷款，与他合作的形式，或为他找工作，直到他足够强大，他不需要问别人维持生计。（利25:35）“如果你的兄弟变得贫穷，他的手会变得愚蠢，你就会强化他，无论是陌生人还是居民，他都会和你住在一起。“ 

所以可以看出，<u>迈蒙尼德这个慈善水平的圣经来源是利未记25:35</u>！这个最高级别的慈善实际上与他在“诫命书”（ Book of Commandments）中所写的内容完全平行。即需要支持那些拒绝任何公开慈善的羞耻的穷人 - 这样的人一个人有义务提供援助，帮助他们完全陷入贫困，并使他/她能够迅速得到康复。

唯一真正的区别在于他==扩展了各种类型的援助==，以帮助加强和维护已经开始堕落但尚未完全堕落的人。在他的诫命书中，他只谈到借钱给这个人。在Mishneh Torah，他当然提到贷款，但增加了更多的援助选择：比如朋友之间的礼物，与他形成商业伙伴关系，或为他找工作。所有这些都旨在确保“他不会堕落并且不需要”。



## Rambam’s Ladder

在这里Julie Salamon讲了一个故事：约翰福特（John Ford）参加一个毕业典礼，讲了一个真正的授之以鱼不如授之以渔的故事。福特说：“我发表演讲时，我总是使用这个。”如果你来找我，告诉我你饿了，我有鱼，我不会给你 - 鱼三明治。我会教你如何钓鱼。这是我的哲学。它并不总是奏效，但那是我的理念。“

另一个是亚瑟讲的关于Arthut咖啡馆（Cafiero）的一名六十岁的酗酒堕落者David的故事。“他住在教堂的台阶上，在社区中出名。人们给他带来食物和毯子。这让他足够舒服，拒绝可能让他可以自我挽救生命的帮助。“ 然后作者送给David一双鞋的故事。

之后作者问福特，你会不会给乞丐钱。他说会。如果他遇到讨要食物的乞丐，他<u>会去商店购买一些东西，而不会给一个人钱</u>。我指出他自相矛盾，他回答说矛盾可能是慈善事业DNA的一部分。当人们依靠慈善而不是依靠自己时会受到多大伤害？



whzecomjm
2019年7月4日